package ru.yandex.direct.core.entity.strategy.type.withavgcpv

import ru.yandex.direct.currency.Currency
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.NumberConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.math.BigDecimal

class AvgCpvValidator(private val currency: Currency) : Validator<BigDecimal, Defect<*>> {

    override fun apply(value: BigDecimal?): ValidationResult<BigDecimal, Defect<*>> =
        ModelItemValidationBuilder.of<BigDecimal, Defect<*>>(value)
            .check(CommonConstraints.notNull())
            .check(NumberConstraints.notLessThan(currency.minAvgCpv))
            .check(NumberConstraints.notGreaterThan(currency.maxAvgCpv))
            .result
}
