package ru.yandex.direct.core.entity.strategy.type.withavgcpv

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithAvgCpvConverterSupport :
    CampaignToStrategyConverterSupport<StrategyWithAvgCpv> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithAvgCpv,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.withAvgCpv(campaign.strategy.strategyData.avgCpv)
    }

    override fun getTypeClass() = StrategyWithAvgCpv::class.java
}
