package ru.yandex.direct.core.entity.strategy.type.withavgcpv

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpvAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithAvgCpv>() {

    override fun validate(
        container: StrategyAddOperationContainer,
        vr: ValidationResult<List<StrategyWithAvgCpv>, Defect<*>>
    ): ValidationResult<List<StrategyWithAvgCpv>, Defect<*>> =
        ListValidationBuilder(vr)
            .checkEachBy(StrategyWithAvgCpvValidatorProvider.createAddStrategyValidator(container))
            .result

    override fun getTypeClass() = StrategyWithAvgCpv::class.java
}
