package ru.yandex.direct.core.entity.strategy.type.withavgcpv

import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges

@Component
@ParametersAreNonnullByDefault
class StrategyWithAvgCpvToCampaignConverterSupport : StrategyToCampaignConverterSupport<StrategyWithAvgCpv> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithAvgCpv,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithAvgCpv,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = StrategyWithAvgCpv::class.java

    private fun fill(strategyData: StrategyData, strategy: StrategyWithAvgCpv) {
        strategyData.avgCpv = strategy.avgCpv
        strategyData.payForConversion = true
    }
}
