package ru.yandex.direct.core.entity.strategy.type.withavgcpv;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithAvgCpvTypeRepositorySupport
        extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithAvgCpv> {

    protected StrategyWithAvgCpvTypeRepositorySupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithAvgCpv> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(StrategyWithAvgCpv.AVG_CPV, STRATEGIES.STRATEGY_DATA, "avg_cpv"))
                .build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<StrategyWithAvgCpv> getTypeClass() {
        return StrategyWithAvgCpv.class;
    }
}
