package ru.yandex.direct.core.entity.strategy.type.withavgcpv

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpvUpdateValidationTypeSupport :
    AbstractStrategyUpdateValidationTypeSupport<StrategyWithAvgCpv>() {

    override fun validate(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<MutableList<StrategyWithAvgCpv>, Defect<*>>
    ): ValidationResult<List<StrategyWithAvgCpv>, Defect<*>> {
        val validator = StrategyWithAvgCpvValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass() = StrategyWithAvgCpv::class.java
}
