package ru.yandex.direct.core.entity.strategy.type.withavgcpv

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithAvgCpvValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithAvgCpv>() {

    override fun createStrategyValidator(container: AbstractStrategyOperationContainer) =
        createValidator(container.currency)

    private fun createValidator(currency: Currency) =
        Validator { strategy: StrategyWithAvgCpv ->
            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(StrategyWithAvgCpv.AVG_CPV)
                .checkBy(AvgCpvValidator(currency))

            vb.result
        }
}
