package ru.yandex.direct.core.entity.strategy.type.withbid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithBidConverterSupport : CampaignToStrategyConverterSupport<StrategyWithBid> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithBid,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.withBid(campaign.strategy.strategyData.bid)
    }

    override fun getTypeClass() = StrategyWithBid::class.java
}
