package ru.yandex.direct.core.entity.strategy.type.withbid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithBidAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithBid>() {

    override fun validate(
        container: StrategyAddOperationContainer,
        vr: ValidationResult<List<StrategyWithBid>, Defect<*>>
    ): ValidationResult<List<StrategyWithBid>, Defect<*>> =
        ListValidationBuilder(vr)
            .checkEachBy(StrategyWithBidValidatorProvider.createAddStrategyValidator(container))
            .result

    override fun getTypeClass() = StrategyWithBid::class.java
}
