package ru.yandex.direct.core.entity.strategy.type.withbid;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithBidRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithBid> {

    protected StrategyWithBidRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithBid> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(
                        StrategyWithBid.BID,
                        STRATEGIES.STRATEGY_DATA,
                        "bid"
                )).build();
    }

    @Override
    public Class<StrategyWithBid> getTypeClass() {
        return StrategyWithBid.class;
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }
}
