package ru.yandex.direct.core.entity.strategy.type.withbid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class StrategyWithBidToCampaignConverterSupport : StrategyToCampaignConverterSupport<StrategyWithBid> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithBid,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithBid,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = StrategyWithBid::class.java

    private fun fill(strategyData: StrategyData, strategy: StrategyWithBid) {
        strategyData.bid = strategy.bid
    }
}
