package ru.yandex.direct.core.entity.strategy.type.withbid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithBidUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<StrategyWithBid>() {

    override fun validate(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<MutableList<StrategyWithBid>, Defect<*>>
    ): ValidationResult<List<StrategyWithBid>, Defect<*>> {
        val validator = StrategyWithBidValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass() = StrategyWithBid::class.java
}
