package ru.yandex.direct.core.entity.strategy.type.withbid

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.core.entity.strategy.utils.StrategyModelUtils.isPayForConversionEnabled
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithBidValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithBid>() {

    override fun createStrategyValidator(container: AbstractStrategyOperationContainer) =
        Validator { strategy: StrategyWithBid ->
            val vb = ModelItemValidationBuilder.of(strategy)
            val sum = when (strategy) {
                is StrategyWithWeeklyBudget -> strategy.sum
                else -> null
            }

            vb.item(StrategyWithBid.BID)
                .checkBy(
                    BidValidator(container.currency, sum, container.campaignType(strategy), strategy.type, strategy.isPayForConversionEnabled()),
                    When.notNull()
                )

            vb.result
        }
}
