package ru.yandex.direct.core.entity.strategy.type.withconversion

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithConversionConverterSupport : CampaignToStrategyConverterSupport<StrategyWithConversion> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithConversion,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.withGoalId(campaign.strategy.strategyData.goalId)
    }

    override fun getTypeClass() = StrategyWithConversion::class.java
}
