package ru.yandex.direct.core.entity.strategy.type.withconversion

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithLastBidderRestartTime
import ru.yandex.direct.core.entity.strategy.service.add.AbstractStrategyAddOperationTypeSupport
import ru.yandex.direct.core.entity.strategy.utils.StrategyModelUtils.goalId

@Component
class StrategyWithConversionAddOperationTypeSupport : AbstractStrategyAddOperationTypeSupport<StrategyWithConversion>() {

    override fun onModelsValidated(addModelContainer: StrategyAddOperationContainer, models: List<StrategyWithConversion>) {
        models
            .mapNotNull { it as? StrategyWithLastBidderRestartTime }
            .forEach { updateLastBidderRestartTimeIfNeed(addModelContainer, it) }
    }

    override fun getTypeClass(): Class<StrategyWithConversion> = StrategyWithConversion::class.java

    companion object {
        private fun updateLastBidderRestartTimeIfNeed(container: StrategyAddOperationContainer,
                                                      strategy: StrategyWithLastBidderRestartTime) {
            if ((strategy is AutobudgetAvgCpi || strategy.goalId() != null) && !container.options.isCampaignToPackageStrategyOneshot) {
                strategy.lastBidderRestartTime = container.now
            }
        }

    }
}
