package ru.yandex.direct.core.entity.strategy.type.withconversion

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithConversionAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithConversion>() {

    override fun validate(container: StrategyAddOperationContainer,
                          vr: ValidationResult<List<StrategyWithConversion>, Defect<*>>): ValidationResult<List<StrategyWithConversion>, Defect<*>> {
        val validator = StrategyWithConversionValidatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass(): Class<StrategyWithConversion> = StrategyWithConversion::class.java
}
