package ru.yandex.direct.core.entity.strategy.type.withconversion;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.Strategies;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.Tables.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonLong;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithConversionRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithConversion> {
    protected StrategyWithConversionRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithConversion> createMapper() {
        return baseBuilder()
                .map(jsonLong(
                        StrategyWithConversion.GOAL_ID,
                        STRATEGIES.STRATEGY_DATA,
                        "goal_id"
                ))
                .build();
    }

    @Override
    public Class<StrategyWithConversion> getTypeClass() {
        return StrategyWithConversion.class;
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(Strategies.STRATEGIES.STRATEGY_ID);
    }

}
