package ru.yandex.direct.core.entity.strategy.type.withconversion

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithConversionUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<StrategyWithConversion>() {
    override fun getTypeClass(): Class<StrategyWithConversion> = StrategyWithConversion::class.java

    override fun validate(container: StrategyUpdateOperationContainer,
                          vr: ValidationResult<List<StrategyWithConversion>, Defect<*>>): ValidationResult<List<StrategyWithConversion>, Defect<*>> {
        val validator = StrategyWithConversionValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
