package ru.yandex.direct.core.entity.strategy.type.withconversion

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithConversionValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithConversion>() {

    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<StrategyWithConversion, Defect<*>> =
        Validator { strategy: StrategyWithConversion ->

            val validatorContainer = GoalIdValidator.Companion.ValidationContainer(
                container.strategyGoals(strategy),
                container.campaignType(strategy),
                strategy.type,
                container.availableFeatures,
                container.options.isRequestFromInternalNetwork,
                container.options.isCopy,
                container.options.isCampaignToPackageStrategyOneshot
            )
            val validator = GoalIdValidator(validatorContainer)
            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(StrategyWithConversion.GOAL_ID)
                .checkBy(validator)

            vb.result
        }

}
