package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudget
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithCustomPeriodBudgetConverterSupport :
    CampaignToStrategyConverterSupport<StrategyWithCustomPeriodBudget> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithCustomPeriodBudget,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        val strategyData = campaign.strategy.strategyData
        val autoProlongation = strategyData.autoProlongation
        strategy
            .withBudget(strategyData.budget)
            .withStart(strategyData.start)
            .withFinish(strategyData.finish)
            .withAutoProlongation(autoProlongation != null && autoProlongation == 1L)
    }

    override fun getTypeClass() = StrategyWithCustomPeriodBudget::class.java
}
