package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudget;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudget;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonLocalDate;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithCustomPeriodBudgetRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithCustomPeriodBudget> {
    protected StrategyWithCustomPeriodBudgetRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithCustomPeriodBudget> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(
                        StrategyWithCustomPeriodBudget.BUDGET,
                        STRATEGIES.STRATEGY_DATA,
                        "budget"
                ))
                .map(jsonLocalDate(
                        StrategyWithCustomPeriodBudget.START,
                        STRATEGIES.STRATEGY_DATA,
                        "start"
                ))
                .map(jsonLocalDate(
                        StrategyWithCustomPeriodBudget.FINISH,
                        STRATEGIES.STRATEGY_DATA,
                        "finish"
                ))
                .map(jsonBooleanToLong(
                        StrategyWithCustomPeriodBudget.AUTO_PROLONGATION,
                        STRATEGIES.STRATEGY_DATA,
                        "auto_prolongation"
                ))
                .build();
    }

    @Override
    public Class<StrategyWithCustomPeriodBudget> getTypeClass() {
        return StrategyWithCustomPeriodBudget.class;
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }
}
