package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudget
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class StrategyWithCustomPeriodBudgetToCampaignConverterSupport :
    StrategyToCampaignConverterSupport<StrategyWithCustomPeriodBudget> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithCustomPeriodBudget,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithCustomPeriodBudget,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = StrategyWithCustomPeriodBudget::class.java

    private fun fill(strategyData: StrategyData, strategy: StrategyWithCustomPeriodBudget) {
        strategyData
            .withBudget(strategy.budget)
            .withStart(strategy.start)
            .withFinish(strategy.finish)

        strategyData.autoProlongation = if (strategy.autoProlongation) 1L else 0L
    }
}
