package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpvCustomPeriod
import ru.yandex.direct.core.entity.strategy.service.update.AbstractStrategyUpdateOperationTypeSupport
import ru.yandex.direct.model.AppliedChanges

@Component
class AutobudgetAvgCpvCustomPeriodUpdateTypeSupport : AbstractStrategyUpdateOperationTypeSupport<AutobudgetAvgCpvCustomPeriod>() {
    override fun getTypeClass(): Class<AutobudgetAvgCpvCustomPeriod> = AutobudgetAvgCpvCustomPeriod::class.java

    override fun onChangesApplied(updateContainer: StrategyUpdateOperationContainer,
                                  appliedChanges: List<AppliedChanges<AutobudgetAvgCpvCustomPeriod>>) {
        val helper = StrategyWithCustomPeriodBudgetAndCustomBidChangesHelper()
        appliedChanges.forEach { helper.modifyChanges(updateContainer, it) }
    }
}

