package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.core.validation.constraints.Constraints
import ru.yandex.direct.currency.CurrencyCode
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.math.BigDecimal

class BudgetPreValidator(
    private val currencyCode: CurrencyCode,
    private val minimalBudgetForStrategyCampaigns: BigDecimal
) : Validator<BigDecimal, Defect<*>> {

    override fun apply(value: BigDecimal?): ValidationResult<BigDecimal, Defect<*>> =
        ModelItemValidationBuilder.of<BigDecimal, Defect<*>>(value)
            .check(
                Constraints.cpmNotLessThan(minimalBudgetForStrategyCampaigns, currencyCode),
                When.notNull()
            )
            .result
}
