package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils
import ru.yandex.direct.core.validation.constraints.Constraints
import ru.yandex.direct.currency.CurrencyCode
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.math.BigDecimal
import java.time.LocalDate

class BudgetValidator(
    private val currencyCode: CurrencyCode,
    private val start: LocalDate,
    private val finish: LocalDate
) : Validator<BigDecimal, Defect<*>> {

    override fun apply(value: BigDecimal?): ValidationResult<BigDecimal, Defect<*>> =
        ModelItemValidationBuilder.of<BigDecimal, Defect<*>>(value)
            .check(CommonConstraints.notNull())
            .check(
                Constraints.cpmNotLessThan(
                    CampaignStrategyUtils.calculateMinimalAvailableBudgetForCpmRestartingStrategyWithCustomPeriod(
                        start,
                        finish,
                        currencyCode
                    ),
                    currencyCode
                )
            )
            .check(
                Constraints.cpmNotGreaterThan(
                    CampaignStrategyUtils.calculateMaximumAvailableBudgetForCpmRestartingStrategyWithCustomPeriod(
                        start,
                        finish,
                        currencyCode
                    ),
                    currencyCode
                )
            )
            .result
}
