package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithCustomPeriodAndCustomBidConverterSupport :
    CampaignToStrategyConverterSupport<StrategyWithCustomPeriodBudgetAndCustomBid> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithCustomPeriodBudgetAndCustomBid,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        val strategyData = campaign.strategy.strategyData
        strategy
            .withLastUpdateTime(strategyData.lastUpdateTime)
            .withDailyChangeCount(strategyData.dailyChangeCount)
    }

    override fun getTypeClass() = StrategyWithCustomPeriodBudgetAndCustomBid::class.java
}
