package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.DateConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.time.LocalDate

class FinishPreValidator(
    private val now: LocalDate
) : Validator<LocalDate, Defect<*>> {

    override fun apply(value: LocalDate?): ValidationResult<LocalDate, Defect<*>> =
        ModelItemValidationBuilder.of<LocalDate, Defect<*>>(value)
            .check(
                DateConstraints.isNotBeforeThan(now),
                When.notNull()
            )
            .result
}
