package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.core.entity.campaign.model.WithDates
import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.strategy.CampaignWithCustomStrategyValidator
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.DateConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.time.LocalDate

class FinishValidator(
    private val now: LocalDate,
    private val start: LocalDate,
    private val campaigns: Collection<WithDates>
) : Validator<LocalDate, Defect<*>> {

    override fun apply(value: LocalDate?): ValidationResult<LocalDate, Defect<*>> {
        val fullDaysCount = value?.let {
            CampaignWithCustomStrategyValidator.getFullDaysCount(
                it,
                start,
                now
            )
        } ?: 0

        return ModelItemValidationBuilder.of<LocalDate, Defect<*>>(value)
            .check(CommonConstraints.notNull())
            .check(DateConstraints.endDateIsNotBeforeThan(start), When.notNull())
            .check(
                Constraint.fromPredicate(
                    { fullDaysCount >= CampaignWithCustomStrategyValidator.MIN_STRATEGY_PERIOD_DAYS_COUNT },
                    StrategyDefects.strategyPeriodDaysCountLessThanMin(CampaignWithCustomStrategyValidator.MIN_STRATEGY_PERIOD_DAYS_COUNT),
                )
            )
            .check(
                Constraint.fromPredicate(
                    { fullDaysCount <= CampaignWithCustomStrategyValidator.MAX_STRATEGY_PERIOD_DAYS_COUNT },
                    StrategyDefects.strategyPeriodDaysCountMoreThanMax(CampaignWithCustomStrategyValidator.MAX_STRATEGY_PERIOD_DAYS_COUNT),
                )
            )
            .check(
                Constraint.fromPredicate(
                    {
                        campaigns
                            .mapNotNull(WithDates::getEndDate)
                            .none(it::isAfter)
                    },
                    StrategyDefects.strategyEndDateIsAfterCampaignEndDate()
                )
            )
            .result
    }
}
