package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.DateConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.time.LocalDate

class StartPreValidator(
    private val now: LocalDate,
    private val isStrategyChanged: Boolean
) : Validator<LocalDate, Defect<*>> {

    override fun apply(value: LocalDate?): ValidationResult<LocalDate, Defect<*>> =
        ModelItemValidationBuilder.of<LocalDate, Defect<*>>(value)
            .check(CommonConstraints.notNull())
            .check(DateConstraints.isNotBeforeThan(now), When.isTrue(isStrategyChanged))
            .result
}
