package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.core.entity.campaign.model.WithDates
import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.strategyStartDateIsBeforeCampaignStartDate
import ru.yandex.direct.validation.builder.Constraint.fromPredicate
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.time.LocalDate

class StartValidator(private val campaigns: Collection<WithDates>) : Validator<LocalDate, Defect<*>> {

    override fun apply(value: LocalDate?): ValidationResult<LocalDate, Defect<*>> =
        ModelItemValidationBuilder.of<LocalDate, Defect<*>>(value)
            .check(CommonConstraints.notNull())
            .check(
                fromPredicate(
                    {
                        campaigns
                            .mapNotNull(WithDates::getStartDate)
                            .none(it::isBefore)
                    },
                    strategyStartDateIsBeforeCampaignStartDate()
                )
            )
            .result
}
