package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class StrategyWithCustomPeriodAndCustomBidToCampaignConverterSupport :
    StrategyToCampaignConverterSupport<StrategyWithCustomPeriodBudgetAndCustomBid> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithCustomPeriodBudgetAndCustomBid,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithCustomPeriodBudgetAndCustomBid,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = StrategyWithCustomPeriodBudgetAndCustomBid::class.java

    private fun fill(strategyData: StrategyData, strategy: StrategyWithCustomPeriodBudgetAndCustomBid) {
        strategyData
            .withLastUpdateTime(strategy.lastUpdateTime)
            .withDailyChangeCount(strategy.dailyChangeCount)
    }
}
