package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid
import ru.yandex.direct.core.entity.strategy.service.add.AbstractStrategyAddOperationTypeSupport
import java.time.LocalDateTime

@Component
class StrategyWithCustomPeriodBudgetAndCustomBidAddTypeSupport :
    AbstractStrategyAddOperationTypeSupport<StrategyWithCustomPeriodBudgetAndCustomBid>() {
    override fun onModelsValidated(addModelContainer: StrategyAddOperationContainer,
                                   models: List<StrategyWithCustomPeriodBudgetAndCustomBid>) {
        val now = LocalDateTime.now()
        models.forEach { if (!addModelContainer.options.isCampaignToPackageStrategyOneshot) initStrategyUpdatesCountInformation(now, it) }
    }

    private fun initStrategyUpdatesCountInformation(
        now: LocalDateTime,
        strategy: StrategyWithCustomPeriodBudgetAndCustomBid) {
        strategy.lastUpdateTime = now
        strategy.dailyChangeCount = 1L
    }

    override fun getTypeClass() = StrategyWithCustomPeriodBudgetAndCustomBid::class.java
}
