package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithCustomPeriodBudgetAndCustomBidAddValidationTypeSupport :
    AbstractStrategyAddValidationTypeSupport<StrategyWithCustomPeriodBudgetAndCustomBid>() {

    override fun validate(
        container: StrategyAddOperationContainer,
        vr: ValidationResult<List<StrategyWithCustomPeriodBudgetAndCustomBid>, Defect<*>>
    ): ValidationResult<List<StrategyWithCustomPeriodBudgetAndCustomBid>, Defect<*>> {
        val validator =
            StrategyWithCustomPeriodBudgetAndCustomBidValidatorProvider.createAddStrategyValidator(
                container
            )

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass() = StrategyWithCustomPeriodBudgetAndCustomBid::class.java
}
