package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndAvgCpm
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.direct.utils.CommonUtils
import java.time.LocalDate
import java.time.LocalDateTime

class StrategyWithCustomPeriodBudgetAndCustomBidChangesHelper {

    fun modifyChanges(updateContainer: StrategyUpdateOperationContainer,
                      ac: AppliedChanges<out StrategyWithCustomPeriodBudgetAndCustomBid>) {
        when {
            dailyChangeCounterShouldIncrease(updateContainer.now, ac) -> {
                ac.model.lastUpdateTime = updateContainer.now
                ac.model.dailyChangeCount = CommonUtils.nvl(ac.getOldValue(StrategyWithCustomPeriodBudgetAndAvgCpm.DAILY_CHANGE_COUNT), 0L) + 1
            }
            dailyChangeCounterShouldReset(updateContainer.now, ac) -> {
                ac.model.lastUpdateTime = updateContainer.now
                ac.model.dailyChangeCount = 1L
            }
            else -> {
                ac.model.lastUpdateTime = ac.getOldValue(StrategyWithCustomPeriodBudgetAndAvgCpm.LAST_UPDATE_TIME)
                ac.model.dailyChangeCount = ac.getOldValue(StrategyWithCustomPeriodBudgetAndAvgCpm.DAILY_CHANGE_COUNT)
            }
        }
    }


    private fun dailyChangeCounterShouldReset(now: LocalDateTime,
                                              ac: AppliedChanges<out StrategyWithCustomPeriodBudgetAndCustomBid>) =
        !isCpmStrategyShouldNotRestart(ac) ||
            (!isStrategyLastChangeWasToday(now, ac) && hasChangesInStrategyToChangeDailyChangeCount(ac))

    private fun dailyChangeCounterShouldIncrease(now: LocalDateTime,
                                                 ac: AppliedChanges<out StrategyWithCustomPeriodBudgetAndCustomBid>) =
        isCpmStrategyShouldNotRestart(ac) &&
            isStrategyLastChangeWasToday(now, ac) &&
            isStrategyAlreadyStartedAndNotFinished(now.toLocalDate(), ac) &&
            hasChangesInStrategyToChangeDailyChangeCount(ac)

    private fun isCpmStrategyShouldNotRestart(ac: AppliedChanges<out StrategyWithCustomPeriodBudgetAndCustomBid>): Boolean =
        !ac.changed(StrategyWithCustomPeriodBudgetAndAvgCpm.TYPE) &&
            !ac.changed(StrategyWithCustomPeriodBudgetAndAvgCpm.START)

    private fun isStrategyLastChangeWasToday(now: LocalDateTime,
                                             ac: AppliedChanges<out StrategyWithCustomPeriodBudgetAndCustomBid>) =
        now.toLocalDate() == ac.getOldValue(StrategyWithCustomPeriodBudgetAndAvgCpm.LAST_UPDATE_TIME)?.toLocalDate()

    private fun isStrategyAlreadyStartedAndNotFinished(now: LocalDate, ac: AppliedChanges<out StrategyWithCustomPeriodBudgetAndCustomBid>) =
        ac.getOldValue(StrategyWithCustomPeriodBudgetAndAvgCpm.START) != null &&
            ac.getOldValue(StrategyWithCustomPeriodBudgetAndAvgCpm.FINISH) != null &&
            !now.isBefore(ac.getOldValue(StrategyWithCustomPeriodBudgetAndAvgCpm.START)) &&
            !now.isAfter(ac.getOldValue(StrategyWithCustomPeriodBudgetAndAvgCpm.FINISH))

    private fun hasChangesInStrategyToChangeDailyChangeCount(ac: AppliedChanges<out StrategyWithCustomPeriodBudgetAndCustomBid>): Boolean =
        ac.changed(StrategyWithCustomPeriodBudgetAndAvgCpm.BUDGET) ||
            ac.changed(StrategyWithCustomPeriodBudgetAndAvgCpm.FINISH) ||
            ac.actuallyChangedProps.contains(StrategyWithCustomPeriodBudgetAndAvgCpm.AVG_CPM)
}
