package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonLocalDateTime;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonLong;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithCustomPeriodBudgetAndCustomBidRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithCustomPeriodBudgetAndCustomBid> {
    protected StrategyWithCustomPeriodBudgetAndCustomBidRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithCustomPeriodBudgetAndCustomBid> createMapper() {
        return baseBuilder()
                .map(jsonLocalDateTime(
                        StrategyWithCustomPeriodBudgetAndCustomBid.LAST_UPDATE_TIME,
                        STRATEGIES.STRATEGY_DATA,
                        "last_update_time"
                ))
                .map(jsonLong(
                        StrategyWithCustomPeriodBudgetAndCustomBid.DAILY_CHANGE_COUNT,
                        STRATEGIES.STRATEGY_DATA,
                        "daily_change_count"
                ))
                .build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<StrategyWithCustomPeriodBudgetAndCustomBid> getTypeClass() {
        return StrategyWithCustomPeriodBudgetAndCustomBid.class;
    }

}
