package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import one.util.streamex.EntryStream
import one.util.streamex.StreamEx
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CpmCampaignWithCustomStrategy
import ru.yandex.direct.core.entity.campaign.service.CampaignStrategyService
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid
import ru.yandex.direct.core.entity.strategy.validation.StrategyValidationUtils
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import java.math.BigDecimal

@Component
class StrategyWithCustomPeriodBudgetAndCustomBidUpdateValidationTypeSupport(val campaignStrategyService: CampaignStrategyService) :
    AbstractStrategyUpdateValidationTypeSupport<StrategyWithCustomPeriodBudgetAndCustomBid>() {
    override fun validateBeforeApply(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<List<ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid>>, Defect<*>>,
        unmodifiedModels: Map<Long, StrategyWithCustomPeriodBudgetAndCustomBid>
    ): ValidationResult<List<ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid>>, Defect<*>> {
        val strategyWithCustomPeriodBudgetAndCustomBidContainer =
            StrategyWithCustomPeriodBudgetAndCustomBidUpdateOperationContainer(
                unmodifiedModels,
                getMinimalBudgetForStrategiesCampaigns(container, unmodifiedModels, vr.value)
            )

        val validator = StrategyWithCustomPeriodBudgetAndCustomBidValidatorProvider
            .createUpdateStrategyBeforeApplyValidator(container, strategyWithCustomPeriodBudgetAndCustomBidContainer)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun validate(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<List<StrategyWithCustomPeriodBudgetAndCustomBid>, Defect<*>>
    ): ValidationResult<List<StrategyWithCustomPeriodBudgetAndCustomBid>, Defect<*>> =
        ListValidationBuilder(vr)
            .checkEachBy(
                StrategyWithCustomPeriodBudgetAndCustomBidValidatorProvider.createUpdateStrategyValidator(
                    container
                )
            )
            .result

    private fun getMinimalBudgetForStrategiesCampaigns(
        container: StrategyUpdateOperationContainer,
        unmodifiedModels: Map<Long, StrategyWithCustomPeriodBudgetAndCustomBid>,
        modelChanges: List<ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid>>
    ): Map<Long, BigDecimal> {
        val strategiesCampaignsBySid = unmodifiedModels.mapValues { strategyBySid ->
            container.campaigns(strategyBySid.value).mapNotNull { it as? CpmCampaignWithCustomStrategy }
        }

        val modifiedStrategiesFinishesBySid =
            StreamEx.of(modelChanges)
                .mapToEntry({ it.id }) { mc ->
                    StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                        mc,
                        StrategyWithCustomPeriodBudgetAndCustomBid.FINISH,
                        unmodifiedModels[mc.id]?.finish
                            ?: throw IllegalArgumentException("No strategy with strategy id {${mc.id}}")
                    )
                }.toMap()

        val campaignsAndStrategiesInfoForMinimalAvailableBudget = unmodifiedModels
            .mapValues { strategyBySid ->
                modifiedStrategiesFinishesBySid[strategyBySid.key]?.let { modifiedStrategyFinish ->
                    strategiesCampaignsBySid[strategyBySid.key]!!.map {
                        CpmCampaignAndCpmNotRestartingStrategyWithCustomPeriodInfo(
                            it,
                            strategyBySid.value.start,
                            modifiedStrategyFinish,
                            strategyBySid.value.budget
                        )
                    }
                }
            }.values.filterNotNull().flatten()

        val minimalAvailableBudgetByCid =
            campaignStrategyService.calculateMinimalAvailableBudgetForCpmNotRestartingStrategyWithCustomPeriod(
                campaignsAndStrategiesInfoForMinimalAvailableBudget,
                container.currency.code
            )

        return EntryStream.of(unmodifiedModels).mapValues { unmodifiedStrategy ->
            val strategyCampaignsIds = strategiesCampaignsBySid[unmodifiedStrategy.id]!!.map { it.id }

            minimalAvailableBudgetByCid.filterKeys { strategyCampaignsIds.contains(it) }
                .values.maxOrNull() ?: BigDecimal.ZERO
        }.toMap()
    }

    override fun getTypeClass() = StrategyWithCustomPeriodBudgetAndCustomBid::class.java
}
