package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.core.entity.campaign.model.WithDates
import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid
import ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid.StrategyWithCustomPeriodBudgetAndCustomBidValidatorProviderHelper.isCpmStrategyShouldNotRestart
import ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid.StrategyWithCustomPeriodBudgetAndCustomBidValidatorProviderHelper.isCpmStrategyWithCustomPeriodChangedForCheckFinishDate
import ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid.StrategyWithCustomPeriodBudgetAndCustomBidValidatorProviderHelper.isCpmStrategyWithCustomPeriodChangedForCheckStartDate
import ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid.StrategyWithCustomPeriodBudgetAndCustomBidValidatorProviderHelper.isStrategyAlreadyStartedAndNotFinished
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProviderWithTypeSpecificContainer
import ru.yandex.direct.core.entity.strategy.validation.StrategyValidationUtils
import ru.yandex.direct.currency.CurrencyCode
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.math.BigDecimal
import java.time.LocalDate

object StrategyWithCustomPeriodBudgetAndCustomBidValidatorProvider :
    AbstractStrategyValidatorProviderWithTypeSpecificContainer<StrategyWithCustomPeriodBudgetAndCustomBid, StrategyWithCustomPeriodBudgetAndCustomBidUpdateOperationContainer>() {
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer) =
        Validator { strategy: StrategyWithCustomPeriodBudgetAndCustomBid ->
            val vb = ModelItemValidationBuilder.of(strategy)

            val campaignsWithDates = container.campaigns(strategy).mapNotNull { it as? WithDates }

            vb.item(StrategyWithCustomPeriodBudget.START)
                .checkBy(StartValidator(campaignsWithDates))

            strategy.start?.let {
                vb.item(StrategyWithCustomPeriodBudget.FINISH)
                    .checkBy(
                        FinishValidator(
                            container.now.toLocalDate(),
                            it,
                            campaignsWithDates
                        )
                    )
            }

            if (strategy.start != null && strategy.finish != null) {
                vb.item(StrategyWithCustomPeriodBudget.BUDGET)
                    .checkBy(
                        BudgetValidator(
                            container.currency.code,
                            strategy.start,
                            strategy.finish
                        )
                    )
            }

            vb.result
        }

    override fun createUpdateStrategyBeforeApplyValidator(
        container: StrategyUpdateOperationContainer,
        typeSpecificContainer: StrategyWithCustomPeriodBudgetAndCustomBidUpdateOperationContainer
    ) =
        createUpdateBeforeApplyValidator(
            container.now.toLocalDate(),
            container.currency.code,
            typeSpecificContainer.minimalBudgetForStrategiesCampaigns,
            typeSpecificContainer.unmodifiedModels
        )

    private fun createUpdateBeforeApplyValidator(
        now: LocalDate,
        currencyCode: CurrencyCode,
        minimalBudgetForStrategiesCampaigns: Map<Long, BigDecimal>,
        unmodifiedModels: Map<Long, StrategyWithCustomPeriodBudgetAndCustomBid>
    ) =
        Validator { strategyChanges: ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid> ->
            val unmodifiedStrategy = unmodifiedModels[strategyChanges.id]
                ?: throw IllegalArgumentException("No changes for strategy with strategy id {${strategyChanges.id}}")
            val vb = ModelItemValidationBuilder.of(strategyChanges, Defect::class.java)

            vb.check(UpdateTimeoutValidator.validate(unmodifiedStrategy, now))

            val modifiedStrategyFinish = StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.FINISH,
                unmodifiedStrategy.finish
            )

            vb.item(
                modifiedStrategyFinish,
                StrategyWithCustomPeriodBudgetAndCustomBid.FINISH.name()
            ).checkBy(
                FinishPreValidator(now),
                When.isTrue(
                    isCpmStrategyWithCustomPeriodChangedForCheckFinishDate(
                        unmodifiedStrategy, strategyChanges
                    )
                )
            )

            val modifiedStrategyStart = StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.START,
                unmodifiedStrategy.start
            )

            vb.item(
                modifiedStrategyStart,
                StrategyWithCustomPeriodBudgetAndCustomBid.START.name()
            ).checkBy(
                StartPreValidator(
                    now,
                    isCpmStrategyWithCustomPeriodChangedForCheckStartDate(
                        unmodifiedStrategy, strategyChanges
                    )
                )
            )

            val needToCheckBudget =
                isCpmStrategyShouldNotRestart(
                    unmodifiedStrategy,
                    strategyChanges
                ) && isStrategyAlreadyStartedAndNotFinished(unmodifiedStrategy, now)

            val modifiedStrategyBudget = StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.BUDGET,
                unmodifiedStrategy.budget
            )

            vb.item(
                modifiedStrategyBudget,
                StrategyWithCustomPeriodBudgetAndCustomBid.BUDGET.name()
            ).checkBy(
                BudgetPreValidator(
                    currencyCode,
                    minimalBudgetForStrategiesCampaigns[strategyChanges.id] ?: BigDecimal.ZERO
                ),
                When.isTrue(needToCheckBudget)
            )

            vb.result
        }

}
