package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid
import ru.yandex.direct.core.entity.strategy.utils.StrategyModelUtils.avgCpm
import ru.yandex.direct.core.entity.strategy.validation.StrategyValidationUtils
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.utils.NumberUtils
import java.time.LocalDate

object StrategyWithCustomPeriodBudgetAndCustomBidValidatorProviderHelper {

    private val STRATEGY_TYPES_WITH_CUSTOM_PERIOD_BUDGET_AND_CUSTOM_BID = setOf(
        StrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD,
        StrategyName.AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD,
        StrategyName.AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD
    )

    fun isStrategyAlreadyStartedAndNotFinished(
        strategy: StrategyWithCustomPeriodBudgetAndCustomBid,
        now: LocalDate
    ): Boolean {
        return strategy.start != null && strategy.finish != null &&
                !now.isBefore(strategy.start) && !now.isAfter(strategy.finish)
    }

    fun isCpmStrategyShouldNotRestart(
        unmodifiedStrategy: StrategyWithCustomPeriodBudgetAndCustomBid,
        strategyChanges: ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid>
    ): Boolean {
        val modifiedStrategyType = StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
            strategyChanges,
            StrategyWithCustomPeriodBudgetAndCustomBid.TYPE,
            unmodifiedStrategy.type
        )

        val modifiedStrategyStart = StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
            strategyChanges,
            StrategyWithCustomPeriodBudgetAndCustomBid.START,
            unmodifiedStrategy.start
        )

        return unmodifiedStrategy.type == modifiedStrategyType && unmodifiedStrategy.start == modifiedStrategyStart
    }

    fun isCpmStrategyWithCustomPeriodChangedForCheckStartDate(
        unmodifiedStrategy: StrategyWithCustomPeriodBudgetAndCustomBid,
        strategyChanges: ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid>
    ): Boolean {
        val modifiedStrategyType =
            StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.TYPE,
                unmodifiedStrategy.type
            )

        val modifiedStrategyStart =
            StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.START,
                unmodifiedStrategy.start
            )

        val modifiedStrategyAutoProlongation =
            StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.AUTO_PROLONGATION,
                unmodifiedStrategy.autoProlongation
            )

        val modifiedStrategyBudget =
            StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.BUDGET,
                unmodifiedStrategy.budget
            )

        val excludingFieldsChanged = unmodifiedStrategy.autoProlongation != modifiedStrategyAutoProlongation ||
                !equalCpmInStrategies(unmodifiedStrategy, strategyChanges) ||
                !NumberUtils.equalsByCompareTo(unmodifiedStrategy.budget, modifiedStrategyBudget)

        return (!STRATEGY_TYPES_WITH_CUSTOM_PERIOD_BUDGET_AND_CUSTOM_BID.contains(modifiedStrategyType) && excludingFieldsChanged)
                || unmodifiedStrategy.type != modifiedStrategyType
                || unmodifiedStrategy.start != modifiedStrategyStart
    }

    fun isCpmStrategyWithCustomPeriodChangedForCheckFinishDate(
        unmodifiedStrategy: StrategyWithCustomPeriodBudgetAndCustomBid,
        strategyChanges: ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid>
    ): Boolean {
        val modifiedStrategyType =
            StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.TYPE,
                unmodifiedStrategy.type
            )

        val modifiedStrategyStart =
            StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.START,
                unmodifiedStrategy.start
            )

        val modifiedStrategyFinish =
            StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.FINISH,
                unmodifiedStrategy.finish
            )

        val modifiedStrategyAutoProlongation =
            StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.AUTO_PROLONGATION,
                unmodifiedStrategy.autoProlongation
            )

        val modifiedStrategyBudget =
            StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                strategyChanges,
                StrategyWithCustomPeriodBudgetAndCustomBid.BUDGET,
                unmodifiedStrategy.budget
            )

        val excludingFieldsChanged = unmodifiedStrategy.autoProlongation != modifiedStrategyAutoProlongation
        return (!STRATEGY_TYPES_WITH_CUSTOM_PERIOD_BUDGET_AND_CUSTOM_BID.contains(modifiedStrategyType) && excludingFieldsChanged)
                || !equalCpmInStrategies(unmodifiedStrategy, strategyChanges)
                || unmodifiedStrategy.type != modifiedStrategyType
                || !NumberUtils.equalsByCompareTo(unmodifiedStrategy.budget, modifiedStrategyBudget)
                || unmodifiedStrategy.start != modifiedStrategyStart
                || unmodifiedStrategy.finish != modifiedStrategyFinish
    }

    private fun equalCpmInStrategies(
        unmodifiedStrategy: StrategyWithCustomPeriodBudgetAndCustomBid,
        strategyChanges: ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid>
    ): Boolean {
        val cpmStrategyChanges = strategyChanges as? ModelChanges<StrategyWithAvgCpm>
            ?: return unmodifiedStrategy.avgCpm() == null

        val modifiedStrategyAvgCpm = StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
            cpmStrategyChanges,
            StrategyWithAvgCpm.AVG_CPM,
            unmodifiedStrategy.avgCpm()
        )

        return if (unmodifiedStrategy.avgCpm() != null) {
            NumberUtils.equalsByCompareTo(unmodifiedStrategy.avgCpm(), modifiedStrategyAvgCpm);
        } else false
    }
}
