package ru.yandex.direct.core.entity.strategy.type.withcustomperiodbudgetandcustombid

import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.strategy.CpmCampaignWithCustomStrategyBeforeApplyValidator
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudgetAndCustomBid
import ru.yandex.direct.core.entity.strategy.validation.StrategyValidationUtils
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.result.Defect
import java.time.LocalDate

class UpdateTimeoutValidator {

    companion object {
        fun validate(
            unmodifiedStrategy: StrategyWithCustomPeriodBudgetAndCustomBid,
            now: LocalDate
        ): Constraint<ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid>, Defect<*>> {
            return Constraint.fromPredicate(
                { strategyChanges: ModelChanges<StrategyWithCustomPeriodBudgetAndCustomBid> ->
                    val modifiedStrategyStart =
                        StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                            strategyChanges,
                            StrategyWithCustomPeriodBudgetAndCustomBid.START,
                            unmodifiedStrategy.start
                        )

                    val modifiedStrategyType = StrategyValidationUtils.getStrategyPropIfChangedOrDefault(
                        strategyChanges,
                        StrategyWithCustomPeriodBudgetAndCustomBid.TYPE,
                        unmodifiedStrategy.type
                    )

                    unmodifiedStrategy.type != modifiedStrategyType
                            || !(!now.isBefore(modifiedStrategyStart)
                            && modifiedStrategyStart == unmodifiedStrategy.start
                            && unmodifiedStrategy.lastUpdateTime != null
                            && now == unmodifiedStrategy.lastUpdateTime.toLocalDate()
                            && unmodifiedStrategy.dailyChangeCount >= CpmCampaignWithCustomStrategyBeforeApplyValidator.CPM_STRATEGY_MAX_DAILY_CHANGE_COUNT)
                },
                StrategyDefects.strategyChangingLimitWasExceeded(CpmCampaignWithCustomStrategyBeforeApplyValidator.CPM_STRATEGY_MAX_DAILY_CHANGE_COUNT)
            )
        }
    }
}
