package ru.yandex.direct.core.entity.strategy.type.withdaybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.common.util.RepositoryUtils
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.DayBudgetShowMode
import ru.yandex.direct.core.entity.campaign.model.WithDayBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyDayBudgetShowMode
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.math.BigDecimal
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithDayBudgetConverterSupport : CampaignToStrategyConverterSupport<StrategyWithDayBudget> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithDayBudget,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        if (campaign is WithDayBudget) {
            val dayBudgetLastChange =
                if (RepositoryUtils.NOW_PLACEHOLDER.equals(campaign.dayBudgetLastChange)) now else campaign.dayBudgetLastChange
            strategy.withDayBudget(campaign.dayBudget)
                .withDayBudgetDailyChangeCount(campaign.dayBudgetDailyChangeCount?.toInt())
                .withDayBudgetLastChange(dayBudgetLastChange)
                .withDayBudgetShowMode(campaign.dayBudgetShowMode?.let(::toStrategyShowMode))
        } else {
            //проставляем дефолты DIRECT-162944
            strategy.withDayBudget(BigDecimal.ZERO)
                .withDayBudgetDailyChangeCount(0)
                .withDayBudgetShowMode(StrategyDayBudgetShowMode.DEFAULT_)
        }
    }

    override fun getTypeClass() = StrategyWithDayBudget::class.java

    companion object {
        private fun toStrategyShowMode(showMode: DayBudgetShowMode): StrategyDayBudgetShowMode {
            return StrategyDayBudgetShowMode.valueOf(showMode.name)
        }
    }
}
