package ru.yandex.direct.core.entity.strategy.type.withdaybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.service.add.AbstractStrategyAddOperationTypeSupport
import ru.yandex.direct.utils.NumberUtils
import java.time.LocalDateTime

@Component
class StrategyWithDayBudgetAddTypeSupport : AbstractStrategyAddOperationTypeSupport<StrategyWithDayBudget>() {
    override fun getTypeClass(): Class<StrategyWithDayBudget> = StrategyWithDayBudget::class.java

    // from CampaignWithCustomDayBudgetAddOperationSupport
    override fun onPreValidated(addContainer: StrategyAddOperationContainer,
                                models: List<StrategyWithDayBudget>) {
        models.forEach { onPreValidated(it, addContainer.now) }
    }

    private fun onPreValidated(strategy: StrategyWithDayBudget,
                               now: LocalDateTime) {
        strategy.dayBudgetDailyChangeCount = 0

        if (NumberUtils.greaterThanZero(strategy.dayBudget)) {
            strategy.dayBudgetLastChange = now
        }
    }
}
