package ru.yandex.direct.core.entity.strategy.type.withdaybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithDayBudgetAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithDayBudget>() {
    override fun getTypeClass(): Class<StrategyWithDayBudget> = StrategyWithDayBudget::class.java

    override fun validate(container: StrategyAddOperationContainer,
                          vr: ValidationResult<List<StrategyWithDayBudget>, Defect<*>>): ValidationResult<List<StrategyWithDayBudget>, Defect<*>> {
        val validator = StrategyWithDayBudgetValidatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
