package ru.yandex.direct.core.entity.strategy.type.withdaybudget;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyDayBudgetShowMode;
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.integerProperty;
import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithDayBudgetRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithDayBudget> {
    protected StrategyWithDayBudgetRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithDayBudget> createMapper() {
        return baseBuilder()
                .map(property(StrategyWithDayBudget.DAY_BUDGET, STRATEGIES.DAY_BUDGET))
                .map(convertibleProperty(
                        StrategyWithDayBudget.DAY_BUDGET_SHOW_MODE,
                        STRATEGIES.DAY_BUDGET_SHOW_MODE,
                        StrategyDayBudgetShowMode::fromSource,
                        StrategyDayBudgetShowMode::toSource
                ))
                .map(integerProperty(
                        StrategyWithDayBudget.DAY_BUDGET_DAILY_CHANGE_COUNT,
                        STRATEGIES.DAY_BUDGET_DAILY_CHANGE_COUNT
                ))
                .map(property(StrategyWithDayBudget.DAY_BUDGET_LAST_CHANGE, STRATEGIES.DAY_BUDGET_LAST_CHANGE))
                .build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<StrategyWithDayBudget> getTypeClass() {
        return StrategyWithDayBudget.class;
    }

}
