package ru.yandex.direct.core.entity.strategy.type.withdaybudget

import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault
import org.springframework.stereotype.Component
import ru.yandex.direct.common.util.RepositoryUtils
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDayBudget
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.DayBudgetShowMode
import ru.yandex.direct.core.entity.campaign.model.WithDayBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyDayBudgetShowMode
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.model.ModelChanges

@Component
@ParametersAreNonnullByDefault
class StrategyWithDayBudgetToCampaignConverterSupport : StrategyToCampaignConverterSupport<StrategyWithDayBudget> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithDayBudget,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        if (campaign is CampaignWithDayBudget) {
            val dayBudgetLastChange =
                if (RepositoryUtils.NOW_PLACEHOLDER.equals(strategy.dayBudgetLastChange)) now else strategy.dayBudgetLastChange
            campaign.dayBudget = strategy.dayBudget
            campaign.dayBudgetDailyChangeCount = strategy.dayBudgetDailyChangeCount.toInt()
            campaign.dayBudgetLastChange = dayBudgetLastChange
            campaign.dayBudgetShowMode = toCampaignStrategyShowMode(strategy.dayBudgetShowMode)
        }
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithDayBudget,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        if (CampaignWithDayBudget::class.java.isAssignableFrom(campaignClass)) {
            val dayBudgetLastChange =
                if (RepositoryUtils.NOW_PLACEHOLDER.equals(strategy.dayBudgetLastChange)) now else strategy.dayBudgetLastChange
            modelChanges.castModel(CampaignWithDayBudget::class.java)
                .process(strategy.dayBudget, WithDayBudget.DAY_BUDGET)
                .process(strategy.dayBudgetDailyChangeCount.toInt(), WithDayBudget.DAY_BUDGET_DAILY_CHANGE_COUNT)
                .process(dayBudgetLastChange, WithDayBudget.DAY_BUDGET_LAST_CHANGE)
                .process(toCampaignStrategyShowMode(strategy.dayBudgetShowMode), WithDayBudget.DAY_BUDGET_SHOW_MODE)
        }
    }

    override fun getTypeClass() = StrategyWithDayBudget::class.java

    companion object {
        private fun toCampaignStrategyShowMode(showMode: StrategyDayBudgetShowMode): DayBudgetShowMode {
            return DayBudgetShowMode.valueOf(showMode.name)
        }
    }
}
