package ru.yandex.direct.core.entity.strategy.type.withdaybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyDayBudgetShowMode
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.service.update.AbstractStrategyUpdateOperationTypeSupport
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.direct.utils.NumberUtils

@Component
class StrategyWithDayBudgetUpdateTypeSupport : AbstractStrategyUpdateOperationTypeSupport<StrategyWithDayBudget>() {

    override fun getTypeClass(): Class<StrategyWithDayBudget> = StrategyWithDayBudget::class.java

    override fun onChangesApplied(
        updateContainer: StrategyUpdateOperationContainer,
        appliedChanges: MutableList<AppliedChanges<StrategyWithDayBudget>>
    ) {

        //Если поменялось значение дневного бюджета, и при этом стало не 0 — увеличиваем счетчик кол-ва изменений ДБ
        //за день. Если ли же ДБ выключают, то проставляем режим показа в default
        appliedChanges.forEach {
            if (it.changed(StrategyWithDayBudget.DAY_BUDGET)) {
                if (NumberUtils.greaterThanZero(it.model.dayBudget)) {
                    it.modify(
                        StrategyWithDayBudget.DAY_BUDGET_DAILY_CHANGE_COUNT,
                        it.model.dayBudgetDailyChangeCount + 1
                    )
                } else {
                    it.modify(StrategyWithDayBudget.DAY_BUDGET_SHOW_MODE, StrategyDayBudgetShowMode.DEFAULT_)
                }
                it.modify(StrategyWithDayBudget.DAY_BUDGET_LAST_CHANGE, updateContainer.now)
            }
        }
    }
}
