package ru.yandex.direct.core.entity.strategy.type.withdaybudget

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDayBudget
import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithDayBudgetValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithDayBudget>() {
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<StrategyWithDayBudget, Defect<*>> =
        Validator { strategy: StrategyWithDayBudget ->
            val dayBudgetShowModeValidator = dayBudgetShowModeValidator(strategy, container)
            val dayBudgetValidator = dayBudgetValidator(strategy, container)

            val vb = ModelItemValidationBuilder.of(strategy)
            vb.item(StrategyWithDayBudget.DAY_BUDGET)
                .checkBy(dayBudgetValidator)
            vb.item(StrategyWithDayBudget.DAY_BUDGET_SHOW_MODE)
                .checkBy(dayBudgetShowModeValidator)
            vb.result
        }

    private fun dayBudgetShowModeValidator(strategy: StrategyWithDayBudget,
                                           container: AbstractStrategyOperationContainer): DayBudgetShowModeValidator {
        val validationContainer = DayBudgetShowModeValidator.Companion.ValidationContainer(
            container.wallet,
            strategy.dayBudget,
            container.campaignType(strategy)
        )
        return DayBudgetShowModeValidator(validationContainer)
    }

    private fun dayBudgetValidator(strategy: StrategyWithDayBudget,
                                   container: AbstractStrategyOperationContainer): DayBudgetValidator {
        val validationContainer = DayBudgetValidator.Companion.ValidationContainer(
            container.campaignType(strategy),
            container.currency,
            strategy.dayBudgetDailyChangeCount,
            container.campaigns(strategy).mapNotNull { it as? CampaignWithDayBudget },
            container.wallet
        )

        return DayBudgetValidator(validationContainer)
    }
}
