package ru.yandex.direct.core.entity.strategy.type.withinventoridata;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.InsertValuesStepN;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbschema.ppc.tables.records.StrategyInventoriDataRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static java.util.Arrays.asList;
import static ru.yandex.direct.dbschema.ppc.Tables.STRATEGY_INVENTORI_DATA;

@Repository
@ParametersAreNonnullByDefault
public class StrategyInventoriDataRepository {

    private final DslContextProvider dslContextProvider;
    @Autowired
    public StrategyInventoriDataRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public Map<Long, Long> getStrategyInventoriData(int shard, Collection<Long> strategyIds) {
        return dslContextProvider.ppc(shard)
                .select(STRATEGY_INVENTORI_DATA.STRATEGY_ID, STRATEGY_INVENTORI_DATA.GENERAL_AUCTION_PROBABILITY)
                .from(STRATEGY_INVENTORI_DATA)
                .where(STRATEGY_INVENTORI_DATA.STRATEGY_ID.in(strategyIds))
                .fetchMap(STRATEGY_INVENTORI_DATA.STRATEGY_ID, STRATEGY_INVENTORI_DATA.GENERAL_AUCTION_PROBABILITY);
    }

    public void save(int shard, Map<Long, Long> strategyInventoriData) {
        InsertValuesStepN<StrategyInventoriDataRecord> insertQuery =
                dslContextProvider.ppc(shard).insertInto(STRATEGY_INVENTORI_DATA,
                        asList(STRATEGY_INVENTORI_DATA.STRATEGY_ID, STRATEGY_INVENTORI_DATA.GENERAL_AUCTION_PROBABILITY));
        for (Map.Entry item : strategyInventoriData.entrySet()) {
            insertQuery = insertQuery.values(item.getKey(), item.getValue());
        }
        insertQuery.onDuplicateKeyUpdate().set(STRATEGY_INVENTORI_DATA.GENERAL_AUCTION_PROBABILITY,
                MySQLDSL.values(STRATEGY_INVENTORI_DATA.GENERAL_AUCTION_PROBABILITY)).execute();
    }
}
