package ru.yandex.direct.core.entity.strategy.type.withlastbidderrestarttime

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithLastBidderRestartTime
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithLastBidderRestartTimeConverterSupport :
    CampaignToStrategyConverterSupport<StrategyWithLastBidderRestartTime> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithLastBidderRestartTime,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.lastBidderRestartTime = campaign.strategy.strategyData?.lastBidderRestartTime
    }

    override fun getTypeClass() = StrategyWithLastBidderRestartTime::class.java
}
