package ru.yandex.direct.core.entity.strategy.type.withlastbidderrestarttime

import ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithStrategyValidationUtils
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.core.entity.strategy.model.StrategyWithLastBidderRestartTime
import ru.yandex.direct.model.AppliedChanges
import java.time.LocalDateTime

object StrategyWithLastBidderRestartTimeChangesUtils {
    fun isStrategyModelChanged(
        oldStrategyType: StrategyName,
        newStrategyType: StrategyName
    ): Boolean = (oldStrategyType == StrategyName.AUTOBUDGET_CRR) xor (newStrategyType == StrategyName.AUTOBUDGET_CRR)

    fun modifyLastBidderRestartTime(
        isRestart: Boolean,
        now: LocalDateTime,
        appliedChanges: AppliedChanges<StrategyWithLastBidderRestartTime>
    ) {
        val lastBidderRestartTime =
            if (isRestart) now
            else appliedChanges.getOldValue(StrategyWithLastBidderRestartTime.LAST_BIDDER_RESTART_TIME)
        appliedChanges.modify(StrategyWithLastBidderRestartTime.LAST_BIDDER_RESTART_TIME, lastBidderRestartTime)
    }

    fun isStrategyWithSupportOfLearningStatus(
        strategyType: StrategyName,
        strategyGoalId: Long?
    ) =
        if (strategyType == StrategyName.AUTOBUDGET_AVG_CPI) {
            // не проверяем цель, т.к. цель или присутствует или может быть null
            // если используется дефолтная цель для CPI стратегии
            true
        } else strategyGoalId != null && CampaignWithStrategyValidationUtils.STRATEGY_TYPES_WITH_LEARNING_STATUS.contains(
            strategyType.name.lowercase()
        )
}
