package ru.yandex.direct.core.entity.strategy.type.withlastbidderrestarttime;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithLastBidderRestartTime;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonLocalDateTime;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithLastBidderRestartTimeRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithLastBidderRestartTime> {

    protected StrategyWithLastBidderRestartTimeRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithLastBidderRestartTime> createMapper() {
        return baseBuilder()
                .map(jsonLocalDateTime(
                        StrategyWithLastBidderRestartTime.LAST_BIDDER_RESTART_TIME,
                        STRATEGIES.STRATEGY_DATA,
                        "last_bidder_restart_time"
                        )
                ).build();
    }

    @Override
    public Class<StrategyWithLastBidderRestartTime> getTypeClass() {
        return StrategyWithLastBidderRestartTime.class;
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }
}
